<?php
/*
Plugin Name: Innovation Theme Settings
Description: Settings for the default GetSimple Theme: Innovation
Version: 1.2
Author: Chris Cagle
Author URI: http://chriscagle.me
*/

# get correct id for plugin
$thisfile_innov=basename(__FILE__, ".php");
$innovation_file=GSDATAOTHERPATH .'InnovationSettings.xml';

# add in this plugin's language file
i18n_merge($thisfile_innov) || i18n_merge($thisfile_innov, 'en_US');

# register plugin
register_plugin(
	$thisfile_innov, 								# ID of plugin, should be filename minus php
	i18n_r($thisfile_innov.'/INNOVATION_H3'), 	# Title of plugin
	'1.2', 											# Version of plugin
	'Chris Cagle',									# Author of plugin
	'http://chriscagle.me', 						# Author URL
	i18n_r($thisfile_innov.'/INNOVATION_DESC'), 	# Plugin Description
	'settings', 										# Page type of plugin
	'innovation_show'  								# Function that displays content
);

$hidemenu = false;

add_action('settings-sidebar','createSideMenu',array($thisfile_innov, i18n_r($thisfile_innov.'/INNOVATION_TITLE'))); 
add_action('theme-header','social_css');

function social_css() {
	global $SITEURL;
	echo '<link type="text/css" href="'.$SITEURL.'plugins/InnovationPlugin/social.css" rel="stylesheet">';
}

$services = array(
	'vkontakte',
	'telegram',
	'whatsapp',
	'viber',
	'skype',
	'odnoklassniki',
	'instagram',
	'youtube',
	'facebook',
	'twitter',
	'pinterest',
	'flickr',
	'vimeo',
	'github',
	'linkedin',
	'tumblr',
	'blogger',
	'rss'
);

# get XML data
if (file_exists($innovation_file)) {
	$innovation_data = getXML($innovation_file);
}

function innovation_show() {
	global $SITEURL,$services,$innovation_file, $innovation_data, $thisfile_innov;
	$success=$error=null;
	
	// submitted form
	if (isset($_POST['submit'])) {		
		foreach($services as $var){			
			if ($_POST[$var] != '') {
				if (validate_url($_POST[$var])) {
					$resp[$var] = $_POST[$var];
				} else {
					$error .= i18n_r($thisfile_innov.'/'.strtoupper($var).'_ERROR').' ';
				}
			}			
		}
		
		# if there are no errors, save data
		if (!$error) {
			$xml = @new SimpleXMLElement('<item></item>');
			foreach($services as $var){			
				if(isset($resp[$var])) $xml->addChild($var, $resp[$var]);
			}
							
			if (! $xml->asXML($innovation_file)) {
				$error = i18n_r('CHMOD_ERROR');
			} else {
				$innovation_data = getXML($innovation_file);
				$success = i18n_r('SETTINGS_UPDATED');
			}
		}
	}
	
	?>
	<h3><?php i18n($thisfile_innov.'/INNOVATION_H3'); ?></h3>
	
	<?php 
	if($success) { 
		echo '<p style="color:#669933;"><b>'. $success .'</b></p>';
	} 
	if($error) { 
		echo '<p style="color:#cc0000;"><b>'. $error .'</b></p>';
	}
	?>
	
	<form method="post" action="<?php	echo $_SERVER ['REQUEST_URI']?>">
		
		<?php 
			foreach($services as $var){
				$value = '';
				if(isset($innovation_data->$var)) $value = $innovation_data->$var;
				echo '<p><label for="inn_'.$var.'" >' . i18n_r($thisfile_innov.'/'.strtoupper($var).'_URL') .'</label><input id="inn_'.$var.'" name="'.$var.'" class="text" value="'.$value.'" type="url" /></p>';
			}
		?>

		<p><input type="submit" id="submit" class="submit" value="<?php i18n('BTN_SAVESETTINGS'); ?>" name="submit" /></p>
	</form>
	<hr>
	<h4 style="font-size:16px; font-weight:bold;margin:15px 0;"><?php i18n($thisfile_innov.'/CODE_H3'); ?></h4>
	<p><b><?php i18n($thisfile_innov.'/CODE_UIKIT'); ?></b><br><code style="max-width:96%;min-width:96%;margin:5px 0 0 !important;background:#ddd;display:inline-block;padding:12px 15px;">
	&lt;?php if (function_exists('Innovation_Settings')) { ?&gt;<br>
	&nbsp;&nbsp;&nbsp;&nbsp;&lt;span class="uk-display-inline-block social-color-hover"&gt;&lt;!-- social-bg  social-bg-hover --&gt;<br>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;?php if($innov_settings){<br>
				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;foreach($innov_settings as $id=&gt;$setting){<br>
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if ($setting  != '' ){<br>
						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;echo '&lt;a class="soc-'.$id.'" href="'.$setting.'" target="_blank" title="'.$id.'"&gt;&lt;img class="svg" width="20" height="20" src="'.get_site_url(false).'plugins/InnovationPlugin/svg/'.$id.'.svg" data-uk-svg alt="'.$id.'"&gt;&lt;/a&gt;';<br>
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}<br>
				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}<br>
			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ?&gt;	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;&lt;/span&gt;<br>
	&lt;?php } ?&gt;
	</code></p>
	<p><b><?php i18n($thisfile_innov.'/CODE_OTHER'); ?></b><br><code style="max-width:96%;min-width:96%;margin:5px 0 0 !important;background:#ddd;display:inline-block;padding:12px 15px;">
	&lt;?php if (function_exists('Innovation_Settings')) { ?&gt;<br>
	&nbsp;&nbsp;&nbsp;&nbsp;&lt;div class="social-icons"&gt;<br>
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;?php if($innov_settings){<br>
				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;foreach($innov_settings as $id=&gt;$setting){<br>
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;if ($setting  != '' ){<br>
						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;echo '&lt;a href="'.$setting.'" target="_blank" title="'.$id.'"&gt;&lt;img style="width:25px;" src="'.get_site_url(false).'/plugins/InnovationPlugin/images/'.$id.'.png" alt="'.$id.'"&gt;&lt;/a&gt;';<br>
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}<br>
				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}<br>
			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ?&gt;	<br>
	&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;<br>
	&lt;?php } ?&gt;
	</code></p>
	<?php
}
function Innovation_Settings() {
	$file = GSDATAOTHERPATH . 'InnovationSettings.xml';
	if (file_exists($file)) {
		$p = getXML($file);
		return $p;
	} else {
		return false;
	}
}
$innov_settings = Innovation_Settings();